# Début programme de pilotage SmartLED/NeoPixel - 1 LED
# LED connecté sur D2

# Aka NeoPixels
# Aka WS2812 and others
# Sciencethic 651 028

from time import sleep

# Nous importons le seul élément Arduino de pyfirmata2Ext
from pyfirmata2Ext import Arduino

################################
# Communication avec Plug'Uno
################################
# Instanciation d'un objet représentant la carte Plug'Uino Uno.
# Arduino.AUTODETECT peut être remplacé par l'identifiant de port-série (ex : "COM1").
# Arduino.AUTODETECT peut ne pas fonctionner correctement avec les port-série Bluetooth.
plugUno = Arduino(Arduino.AUTODETECT)

################################
# Utilisation
################################
# Nous definison les valeur rouge/vert/bleu dans un tableau
# Ces valeurs doivent etre comprise entre 0~100
# couleurLED = [ rouge , vert , bleu ]
couleurLED = [ 100 , 100 , 100 ] # blanc

# Commande d'ecritue a la LED sur la broche D2 (2 ou 3)
brocheLED = 2
plugUno.writeSmartLED( brocheLED , couleurLED )

sleep(5)

# Montrer toutes les nuances de Rouge
for i in range(100):
    plugUno.writeSmartLED( brocheLED , [ i , 0 , 0 ] )
    sleep(0.005)

# Montrer toutes les nuances de Vert
for i in range(100):
    plugUno.writeSmartLED( brocheLED , [ 0 , i , 0 ] )
    sleep(0.005)

# Montrer toutes les nuances de Bleu
for i in range(100):
    plugUno.writeSmartLED( brocheLED , [ 0 , 0 , i ] )
    sleep(0.005)


# Fermer la connexion à Plug'Uno avant de quitter.
plugUno.exit()

# Termine l'éxecution du programme Python.
#exit()

# Fin programme de pilotage SmartLED/NeoPixel - 1 LED
